
-- @Author: Ragman2414
-- @Date: 02.12.2021
-- @Version: 1.0.0.0


ReduceMaintenanceSettings = {};
ReduceMaintenanceSettings.name = g_currentModName;
ReduceMaintenanceSettings.modDirectory = g_currentModDirectory

ReduceMaintenanceSettings.tooltipId = 1
ReduceMaintenanceSettings.settingTitleId = 2

function ReduceMaintenanceSettings.init()

    InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, ReduceMaintenanceSettings.initSettingsGui)
end

function ReduceMaintenanceSettings.initSettingsGui(self)
    ---Just check for maintenanceCost
    if self.maintenanceCost == nil then

        -- Section Header
        local title = self.gameSettingsLayout.elements[7]:clone()
        title:applyProfile("fs25_settingsSectionHeader", true)
        title:setText(ReduceMaintenanceSettings:getText("r_maintenance_title"))
        title.focusChangeData={}
        title.focusId = FocusManager.serveAutoFocusId()

        self.gameSettingsLayout:addElement(title)

        local target = g_r_maintenance

        local optionClone = self.economicDifficulty:clone()
        optionClone.target = target
        optionClone.onClickCallback = ReduceMaintenanceSettings.onMaintenanceCostStateChanged
        optionClone.buttonLRChange = ReduceMaintenanceSettings.onMaintenanceCostStateChanged
        optionClone.texts[1] = "25 %"
        optionClone.texts[2] = "50 %"
        optionClone.texts[3] = "75 %"
        optionClone.texts[4] = "100 %"
        optionClone.texts[5] = "125 %"
        optionClone.texts[6] = "150 %"


        self.maintenanceCost = optionClone:clone()
        ReduceMaintenanceSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.maintenanceCost,
            "maintenanceCost",
            "r_maintenance_cost",
            self.gameSettingsLayout.elements[5]
        )

        local state = 4
        if(g_r_maintenance.maintenanceCost ~= nil) then
            state = g_r_maintenance.maintenanceCost / 0.25
        end
        self.maintenanceCost:setState(state)


        --
        self.maintenanceDuration = optionClone:clone()
        ReduceMaintenanceSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.maintenanceDuration,
            "maintenanceDuration",
            "r_maintenance_duration",
            self.gameSettingsLayout.elements[5]
        )

        state = 4
        if(g_r_maintenance.maintenanceDuration ~= nil) then
            state = g_r_maintenance.maintenanceDuration / 0.25
        end
        self.maintenanceDuration:setState(state)

        --
        self.wearCost = optionClone:clone()
        ReduceMaintenanceSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.wearCost,
            "wearCost",
            "r_wear_cost",
            self.gameSettingsLayout.elements[5]
        )

        state = 4
        if(g_r_maintenance.wearCost ~= nil) then
            state = g_r_maintenance.wearCost / 0.25
        end
        self.wearCost:setState(state)

        --
        self.wearDuration = optionClone:clone()
        ReduceMaintenanceSettings:addOptionToLayout(
            self.gameSettingsLayout,
            self.wearDuration,
            "wearDuration",
            "r_wear_duration",
            self.gameSettingsLayout.elements[5]
        )

        state = 4
        if(g_r_maintenance.wearDuration ~= nil) then
            state = g_r_maintenance.wearDuration / 0.25
        end
        self.wearDuration:setState(state)

        --self.maintenanceCost.id = "maintenanceCost"
--
        --local toolTip = self.maintenanceCost.elements[1]
--
        --toolTip.text = ReduceMaintenanceSettings:getText("r_maintenance_cost_tooltip")
        --toolTip.sourceText = ReduceMaintenanceSettings:getText("r_maintenance_cost_tooltip")
--
        --local state = 4
        --if(g_r_maintenance.maintenanceCost ~= nil) then
        --    state = g_r_maintenance.maintenanceCost / 0.25
        --end
        --self.maintenanceCost:setState(state)
--
--
        ----- Create MaintenanceDuration Element
        --self.maintenanceDuration =  self.maintenanceCost:clone()
        --self.maintenanceDuration.id = "maintenanceDuration"
--
        --toolTip = self.maintenanceDuration.elements[1]
--
        --toolTip.text = ReduceMaintenanceSettings:getText("r_maintenance_duration_tooltip")
        --toolTip.sourceText = ReduceMaintenanceSettings:getText("r_maintenance_duration_tooltip")
--
        --state = 4
        --if(g_r_maintenance.maintenanceDuration ~= nil) then
        --    state = g_r_maintenance.maintenanceDuration / 0.25
        --end
        --self.maintenanceDuration:setState(state)
--
        ----- Create WearCost Element
        --self.wearCost =  self.maintenanceCost:clone()
        --self.wearCost.id = "wearCost"
--
        --toolTip = self.wearCost.elements[1]
--
        --toolTip.text = ReduceMaintenanceSettings:getText("r_wear_cost_tooltip")
        --toolTip.sourceText = ReduceMaintenanceSettings:getText("r_wear_cost_tooltip")
--
        --state = 4
        --if(g_r_maintenance.wearCost ~= nil) then
        --    state = g_r_maintenance.wearCost / 0.25
        --end
        --self.wearCost:setState(state)
--
        ----- Create WearDuration Element
        --self.wearDuration =  self.maintenanceCost:clone()
        --self.wearDuration.id = "wearDuration"
--
        --toolTip = self.wearDuration.elements[1]
--
        --toolTip.text = ReduceMaintenanceSettings:getText("r_wear_duration_tooltip")
        --toolTip.sourceText = ReduceMaintenanceSettings:getText("r_wear_duration_tooltip")
--
        --state = 4
        --if(g_r_maintenance.wearDuration ~= nil) then
        --    state = g_r_maintenance.wearDuration / 0.25
        --end
--
        --self.wearDuration:setState(state)
--
        ----local title = TextElement.new()
        --local title = self.gameSettingsLayout.elements[7]:clone()
        --title:applyProfile("fs25_settingsSectionHeader", true)
        --title:setText(ReduceMaintenanceSettings:getText("r_maintenance_title_copy"))
        --title.focusChangeData={}
        --title.focusId = FocusManager.serveAutoFocusId()
        --self.gameSettingsLayout:addElement(title)
--
--
--
        ----- ab hier test
        --local wearDurationElement = self.gameSettingsLayout.elements[5]:clone()
        ----local wearDurationElement = BitmapElement.new()
        --wearDurationElement.id = "wearDurationElement123"
--
        --wearDurationElement:applyProfile("fs25_multiTextOptionContainer", true)
        --for key, v in pairs(wearDurationElement.elements) do
        --    wearDurationElement.elements[key] = nil
        --end
--
        --wearDurationElement:addElement(self.wearDuration)
--
        --local wearDurationTitle = self.gameSettingsLayout.elements[5].elements[2]:clone()
        --wearDurationTitle.id = "wearDurationTitle"
        --wearDurationTitle:applyProfile("fs25_settingsMultiTextOptionTitle", true)
        --wearDurationTitle:setText("Wear Duration123123123123123123")
--
        --wearDurationElement:addElement(wearDurationTitle)
--
        ----self.gameSettingsLayout:addElement(self.maintenanceCost)
        ----self.gameSettingsLayout:addElement(self.maintenanceDuration)
        ----self.gameSettingsLayout:addElement(self.wearCost)
        ----self.gameSettingsLayout:addElement(self.wearDuration)
        --self.gameSettingsLayout:addElement(wearDurationElement)

        self.gameSettingsLayout:invalidateLayout()

    end


end

function ReduceMaintenanceSettings:addOptionToLayout(gameSettingsLayout, cloneElement, id, textId, settingsClone)
    cloneElement.id = id

    local toolTip = cloneElement.elements[1]

    toolTip.text = ReduceMaintenanceSettings:getText(textId.."_tooltip")
    toolTip.sourceText = ReduceMaintenanceSettings:getText(textId.."_tooltip")

    --state = 4
    --if(g_r_maintenance.maintenanceDuration ~= nil) then
    --    state = g_r_maintenance.maintenanceDuration / 0.25
    --end
    --self.maintenanceDuration:setState(state)


    local optionTitle = settingsClone.elements[2]:clone()
    optionTitle.id = id.."Title"
    optionTitle:applyProfile("fs25_settingsMultiTextOptionTitle", true)
    optionTitle:setText(ReduceMaintenanceSettings:getText(textId))

    local optionContainer = settingsClone:clone()
    optionContainer.id = id.."Container"

    optionContainer:applyProfile("fs25_multiTextOptionContainer", true)
    for key, v in pairs(optionContainer.elements) do
        optionContainer.elements[key] = nil
    end

    optionContainer:addElement(optionTitle)
    optionContainer:addElement(cloneElement)
    gameSettingsLayout:addElement(optionContainer)
end

function ReduceMaintenanceSettings:getText(key)
    return g_i18n.modEnvironments[ReduceMaintenanceSettings.name].texts[key]
end

function ReduceMaintenanceSettings:onMaintenanceCostStateChanged(state,x,y,z)
    g_client:getServerConnection():sendEvent(ChangeMaintenanceSettingsEvent.new(x.id, state))
end

ReduceMaintenanceSettings.init()
