-- // 	     Function.lua          \\ --
-- 	  	     No Sleep mod	          --
--    	  	  By Modon55              --
-- \\ Do not change anything below // --



SleepRestriction = {}
SleepRestriction.modName = g_currentModName

function SleepRestriction:loadMap(name)
    if g_sleepManager ~= nil then
        self.originalSleepFunction = g_sleepManager.startSleep
        g_sleepManager.startSleep = function(...)
            return SleepRestriction:preventSleep(...)
        end
    else
        print("[No Sleep] INFO: 'SleepManager' missing or not found")
    end
end

function SleepRestriction:preventSleep(...)
    if g_server ~= nil then
        SleepRestrictionWarningEvent.sendEvent()
    else
        g_currentMission:showBlinkingWarning(g_i18n:getText("sleepwarning"), 5000)
    end
    return false
end


function SleepRestriction:delete()
    if g_sleepManager ~= nil and self.originalSleepFunction ~= nil then
        g_sleepManager.startSleep = self.originalSleepFunction
    end
end

addModEventListener(SleepRestriction)
