--[[
	IngameTimeOperatingHours.lua
	
	Author: 	Ifko[nator]
	Date:		10.05.2025
	Version:	2.1 
	
	History:	v1.0 @27.11.2021 - initial implementation in FS 22
				----------------------------------------------------
				v2.0 @04.01.2025 - convert to FS 25
				----------------------------------------------------
				v2.1 @10.05.2025 - fix for the Precision Farming mod
]]


IngameTimeOperatingHours = {};

function IngameTimeOperatingHours:updateTick(superFunc, dt)
	  if self.isServer then
        local wx, _, _ = getWorldTranslation(self.rootNode);

        if MathUtil.isNan(wx) then
            return;
        end;
    end;
	
	local isActiveForInput = self:getIsActiveForInput();
	local isActiveForInputIgnoreSelection = self:getIsActiveForInput(true);
	local isSelected = self:getIsSelected();

	if self.isActive and self.needWaterInfo then
		self:updateWaterInfo();
	end;

	self.isOnField = self:getIsOnField();

	if self.isServer then
		if self.synchronizePosition then
			local hasOwner = self:getOwnerConnection() ~= nil;

			for componentNumber = 1, #self.components do
				local component = self.components[componentNumber];

				if not component.isStatic then
					local x, y, z = getWorldTranslation(component.node);
					local x_rot, y_rot, z_rot = getWorldRotation(component.node);
					local sentTranslation = component.sentTranslation;
					local sentRotation = component.sentRotation;

					if hasOwner 
						or math.abs(x - sentTranslation[1]) > 0.005
						or math.abs(y - sentTranslation[2]) > 0.005
						or math.abs(z - sentTranslation[3]) > 0.005
						or math.abs(x_rot - sentRotation[1]) > 0.1
						or math.abs(y_rot - sentRotation[2]) > 0.1
						or math.abs(z_rot - sentRotation[3]) > 0.1
					then
						self:raiseDirtyFlags(self.vehicleDirtyFlag);

						sentTranslation[1] = x;
						sentTranslation[2] = y;
						sentTranslation[3] = z;
						sentRotation[1] = x_rot;
						sentRotation[2] = y_rot;
						sentRotation[3] = z_rot;
						
						self.lastMoveTime = g_currentMission.time;
					end;
				end;
			end;
		end;

		self.showTailwaterDepthWarning = false;

		if not self.isBroken and not g_gui:getIsGuiVisible() and self.thresholdTailwaterDepthWarning < self.tailwaterDepth then
			self.showTailwaterDepthWarning = true;

			if self.thresholdTailwaterDepth < self.tailwaterDepth then
				self:setBroken();
			end;
		end;

		local rootAttacherVehicle = self.rootVehicle;

		if rootAttacherVehicle ~= nil and rootAttacherVehicle ~= self then
			rootAttacherVehicle.showTailwaterDepthWarning = rootAttacherVehicle.showTailwaterDepthWarning or self.showTailwaterDepthWarning;
		end;
	end;

	if self:getIsOperating() then
		local operatingTime = dt * g_currentMission.loadingScreen.missionInfo.timeScale;

		self:setOperatingTime(self.operatingTime + operatingTime);
	end;

	SpecializationUtil.raiseEvent(self, "onUpdateTick", dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected);
	SpecializationUtil.raiseEvent(self, "onPostUpdateTick", dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected);
end

Vehicle.updateTick = Utils.overwrittenFunction(Vehicle.updateTick, IngameTimeOperatingHours.updateTick);

function IngameTimeOperatingHours:updateConsumers(superFunc, dt, accInput)
	local specMotorized = self.spec_motorized;

	local idleFactor = 0.5;
	local rpmPercentage = (specMotorized.motor.lastMotorRpm - specMotorized.motor.minRpm) / (specMotorized.motor.maxRpm - specMotorized.motor.minRpm);
	local rpmFactor = idleFactor + rpmPercentage * (1 - idleFactor);
	local loadFactor = math.max(specMotorized.smoothedLoadPercentage * rpmPercentage, 0);
	local motorFactor = 0.5 * (0.2 * rpmFactor + 1.8 * loadFactor);
	local usageFactor = 1;

	local missionInfo = g_currentMission.missionInfo
	local fuelUsage = missionInfo.fuelUsage;
    
	local usageFactor = 1.5; -- medium

    if fuelUsage == 1 then
        usageFactor = 1.0; -- low
    elseif fuelUsage == 3 then
        usageFactor = 2.5; -- high
    end;
	
	local damage = self:getVehicleDamage();
	
	if damage > 0 then
		usageFactor = usageFactor * (1 + damage * Motorized.DAMAGED_USAGE_INCREASE);
	end;

	local timeScale = g_currentMission.loadingScreen.missionInfo.timeScale;
	
	for _, consumer in pairs(specMotorized.consumers) do
		if consumer.permanentConsumption and consumer.usage > 0 then
			local used = usageFactor * motorFactor * consumer.usage * dt * timeScale;
			
			if used ~= 0 then
				consumer.fillLevelToChange = consumer.fillLevelToChange + used;
				
				if math.abs(consumer.fillLevelToChange) > 1 then
					used = consumer.fillLevelToChange;
					
					consumer.fillLevelToChange = 0;

					local fillType = self:getFillUnitLastValidFillType(consumer.fillUnitIndex);

					g_farmManager:updateFarmStats(self:getOwnerFarmId(), "fuelUsage", used);
					
					if self:getIsAIActive() and (fillType == FillType.DIESEL or fillType == FillType.DEF) and missionInfo.helperBuyFuel then
						if fillType == FillType.DIESEL then
							local price = used * g_currentMission.economyManager:getCostPerLiter(fillType) * 1.5;
							
							g_farmManager:updateFarmStats(self:getOwnerFarmId(), "expenses", price);

							g_currentMission:addMoney(-price, self:getOwnerFarmId(), MoneyType.PURCHASE_FUEL, true);
						end;
						
						used = 0;
					end;
					
					if fillType == consumer.fillType then
						self:addFillUnitFillLevel(self:getOwnerFarmId(), consumer.fillUnitIndex, - used, fillType, ToolType.UNDEFINED);
					end;
				end;

				local usage = (used / dt * 1000 * 60 * 60) / timeScale;
				
				if consumer.fillType == FillType.DIESEL or consumer.fillType == FillType.ELECTRICCHARGE or consumer.fillType == FillType.METHANE then
					specMotorized.lastFuelUsage = usage;
				elseif consumer.fillType == FillType.DEF then
					specMotorized.lastDefUsage = usage;
				end;
			end;
		end;
	end;
	
	if specMotorized.consumersByFillTypeName.AIR ~= nil then
		local consumer = specMotorized.consumersByFillTypeName.AIR;
		local fillType = self:getFillUnitLastValidFillType(consumer.fillUnitIndex);
		
		if fillType == consumer.fillType then
			local usage = 0;
			local direction = self.movingDirection * self:getReverserDirection();
			local forwardBrake = direction > 0 and accInput < 0;
			local backwardBrake = direction < 0 and accInput > 0;
			local brakeIsPressed = self:getLastSpeed() > 1 and (forwardBrake or backwardBrake);

			if brakeIsPressed then
				local delta = math.abs(accInput) * dt * self:getAirConsumerUsage() / 1000;
				
				self:addFillUnitFillLevel(self:getOwnerFarmId(), consumer.fillUnitIndex, - delta, consumer.fillType, ToolType.UNDEFINED);
				
				usage = delta / dt * 1000;
			end;
			
			local fillLevelPercentage = self:getFillUnitFillLevelPercentage(consumer.fillUnitIndex);
			
			if fillLevelPercentage < consumer.refillCapacityPercentage then
				consumer.doRefill = true;
			elseif fillLevelPercentage == 1 then
				consumer.doRefill = false;
			end;
			
			if consumer.doRefill then
				local delta = consumer.refillLitersPerSecond / 1000 * dt;
				
				self:addFillUnitFillLevel(self:getOwnerFarmId(), consumer.fillUnitIndex, delta, consumer.fillType, ToolType.UNDEFINED);
				
				usage = -delta / dt * 1000;
			end;
			
			specMotorized.lastAirUsage = usage;
		end;
	end;
end;

Motorized.updateConsumers = Utils.overwrittenFunction(Motorized.updateConsumers, IngameTimeOperatingHours.updateConsumers);