swathingPlus = {}
local modDirectory = g_currentModDirectory
local g_modName = g_currentModName

-- fillType Extender
if FillTypeManager.SEND_NUM_BITS < 9 then
    FillTypeManager.SEND_NUM_BITS = 9
    printf("%s: FillType limit increased to 511", g_modName)
end

-- register fruitTypes.xml
function swathingPlus.registerFruitTypes(self, superFunc)
    superFunc(self)

    local xml = loadXMLFile("swathingPlus", modDirectory.."xml/fruitTypes.xml")
    g_fruitTypeManager:loadFruitTypes(xml, nil, false)
    delete(xml)
end

FruitTypeManager.loadDefaultTypes = Utils.overwrittenFunction(FruitTypeManager.loadDefaultTypes, swathingPlus.registerFruitTypes)

-- add swath to crops
FruitTypeGroundTypeFix = {}

function FruitTypeGroundTypeFix:loadMap(name)
    local function configureFruit(fruitName, cutFillTypeName, patchGroundType)
        local fruit = g_fruitTypeManager:getFruitTypeByName(fruitName)
        if fruit == nil then
            print(string.format("Fruit %s not found", fruitName))
            return
        end

        -- Windrow setup
        local windrowCutFillType = g_fillTypeManager:getFillTypeByName(cutFillTypeName)
        if windrowCutFillType ~= nil then
            fruit.windrowLiterPerSqm = 3.68
            fruit.windrowCutFillType = windrowCutFillType
            fruit.windrowCutFactor = 1.25
            g_fruitTypeManager.windrowCutFillTypeIndexToFruitTypeIndex[windrowCutFillType.index] = fruit.index
        end

        -- GroundType patch
        if patchGroundType then
            fruit.groundTypeChangeType = FieldGroundType.HARVEST_READY
            print(string.format("Patched groundTypeChangeType for %s → HARVEST_READY", fruitName))
        end
    end

					-- fruitType,swath_cut,push HARVEST_READY
    configureFruit("sorghum", "sorghum_cut", true)
    configureFruit("ricelonggrain", "ricelonggrain_cut", true)
end

addModEventListener(FruitTypeGroundTypeFix)
